function [L,gamma_e] = Observer_design(A,F,C,D)

[n,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);

Ce = eye(n+q);

% augmented system
A_bar = [A F; zeros(q,n) zeros(q,q)];
C_bar = [C zeros(p,q)];
D_bar = [D zeros(n,q); zeros(q,l) eye(q)];


Q = sdpvar(n+q,n+q);
Y = sdpvar(n+q,p);
gamma = sdpvar(1,1);

LMI1 = blkvar();
LMI1(1,1) = (Q*A_bar-Y*C_bar)+(Q*A_bar-Y*C_bar)';
LMI1(1,2) = Q*D_bar;
LMI1(1,3) = Ce';

LMI1(2,2) = -gamma*eye(l+q);
LMI1(2,3) = zeros(l+q,n+q);

LMI1(3,3) =-gamma*eye(n+q);

LMI1 = sdpvar(LMI1);

obj = 1.0e-3*gamma;
const = [];

const = [const, gamma >= 0];
const = [const, Q >= eps*eye(n+q)];
const = [const, LMI1 <= -eps*eye(n+q+l+q+n+q)];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
ops = sdpsettings('solver','mosek','verbose',1);
optimize(const,obj,ops);

L = inv(value(Q))*value(Y);
gamma_e = value(gamma);

